<?php
// TEMPORARY ERROR REPORTING (REMOVE AFTER DEBUGGING)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
// END TEMPORARY ERROR REPORTING

// START SESSION AND AUTHENTICATION CHECK
session_start();
// Redirect non-logged-in users to the login page
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: index.php");
    exit();
}

// Include Database Connection
require_once 'config/db_connection.php';

// Determine which section to load based on the 'page' URL parameter
$page = $_GET['page'] ?? 'home';

// Define allowed sections and their file paths
$allowed_sections = [
    'home' => ['title' => 'Welcome', 'file' => null], // Default content						
    'upload_confidential' => ['title' => 'Upload Confidential File', 'file' => 'sections/upload_confidential.php'],	// Section 1
    'manage_users' => ['title' => 'Create User and Assign Role', 'file' => 'sections/manage_users.php'],		// Section 2
    'view_employees' => ['title' => 'Employee Database', 'file' => 'sections/view_employees.php'],			// Section 3
    'manage_documents' => ['title' => 'General Documents Database', 'file' => 'sections/manage_documents.php'], 	// Section 4
    'manage_photos' => ['title' => 'General Photos Database', 'file' => 'sections/manage_photos.php'],       		// Section 5
    'manage_videos' => ['title' => 'General Videos Database', 'file' => 'sections/manage_videos.php'],        		// Section 6
    'manage_cv_bank' => ['title' => 'CV Bank Management', 'file' => 'sections/manage_cv_bank.php'], 			// Section 7 
    'manage_clients' => ['title' => 'All Clients', 'file' => 'sections/manage_clients.php'],    			// Section 8
    'manage_assets' => ['title' => 'Asset Management', 'file' => 'sections/manage_assets.php'], 			// Section 9
    'manage_templates' => ['title' => 'Document Template Manager', 'file' => 'sections/document_maker.php'],		// Section 10    
    'create_activity_report' => ['title' => 'Create My Activity Report', 'file' => 'sections/create_activity_report.php'], //Section 11
    'supervisor_approval' => ['title' => 'Files To Approve', 'file' => 'sections/supervisor_approval.php'],		//Section 12
    'company_letterpad' => ['title' => 'Company Letterpad Generator', 'file' => 'sections/company_letterpad.php'], 	// Section 13 (New)
    
];

// Set the current section details
$current_section = $allowed_sections[$page] ?? $allowed_sections['home'];
$page_title = "Admin Dashboard | " . $current_section['title'];
$content_file = $current_section['file'];

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title; ?></title>
    <style>
        body { font-family: 'Arial', sans-serif; margin: 0; background-color: #f4f7f6; color: #333; }
        .dashboard-container { display: flex; min-height: 100vh; }
        .sidebar { width: 250px; background-color: #2c3e50; padding: 20px 0; box-shadow: 2px 0 5px rgba(0,0,0,0.1); }
        .sidebar h2 { color: #ecf0f1; text-align: center; margin-bottom: 30px; }
        .sidebar nav a { 
            display: block; 
            color: #ecf0f1; 
            padding: 15px 20px; 
            text-decoration: none; 
            font-size: 16px; 
            border-left: 5px solid transparent; 
            transition: all 0.3s;
        }
        .sidebar nav a:hover { 
            background-color: #34495e; 
            border-left-color: #3498db; 
        }
        .sidebar nav a.active { 
            background-color: #34495e; 
            border-left-color: #2ecc71; 
            font-weight: bold;
        }
        .sidebar .logout-btn {
            display: block; 
            margin-top: 40px;
            text-align: center;
        }
        .main-content { 
            flex-grow: 1; 
            padding: 30px; 
            background-color: #ecf0f1;
        }
        .form-card { 
            background-color: #fff; 
            padding: 25px; 
            border-radius: 10px; 
            box-shadow: 0 4px 15px rgba(0,0,0,0.05); 
            margin-bottom: 20px;
        }
        h1 { color: #2c3e50; margin-bottom: 20px; border-bottom: 2px solid #bdc3c7; padding-bottom: 10px; }
        /* Form styling */
        label { display: block; margin-top: 15px; font-weight: bold; color: #34495e; }
        input[type="text"], input[type="password"], input[type="email"], select {
            width: 100%;
            padding: 10px;
            margin-top: 5px;
            border: 1px solid #ccc;
            border-radius: 5px;
            box-sizing: border-box;
        }
        button[type="submit"] {
            background-color: #3498db;
            color: white;
            padding: 12px 20px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            margin-top: 20px;
            font-size: 16px;
            transition: background-color 0.3s;
        }
        button[type="submit"]:hover {
            background-color: #2980b9;
        }
        .data-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        .data-table th, .data-table td {
            border: 1px solid #ddd;
            padding: 10px;
            text-align: left;
        }
        .data-table th {
            background-color: #f2f2f2;
            color: #333;
        }
    </style>
</head>
<body>

<div class="dashboard-container">
    
    <div class="sidebar">
        <h2>Admin Panel</h2>
        <nav>
            <?php foreach ($allowed_sections as $key => $section): ?>
                <a href="admin_dashboard.php?page=<?php echo $key; ?>" 
                   class="<?php echo ($page == $key) ? 'active' : ''; ?>">
                    <?php echo htmlspecialchars($section['title']); ?>
                </a>
            <?php endforeach; ?>
        </nav>
        <div class="logout-btn">
             <a href="logout.php" style="color: #e74c3c; text-decoration: none; font-weight: bold;">Log Out</a>
        </div>
    </div>

    <div class="main-content">
        <h1><?php echo htmlspecialchars($current_section['title']); ?></h1>
        
        <?php
        // --- Dynamic Content Inclusion ---
        if ($content_file && file_exists($content_file)) {
            // Include the specific section file (e.g., sections/manage_users.php)
            require_once $content_file;
        } elseif ($page === 'home') {
            // Default home content
            echo "<div class='form-card'>";
            echo "<h2>Welcome, Admin!</h2>";
            echo "<p>Use the navigation panel on the left to access the system management tools.</p>";
            echo "<p>This secure dashboard allows you to manage users, databases, and confidential files.</p>";
            echo "</div>";
        } else {
             // Handle files that are placeholders OR files that were not found.
            echo "<div class='form-card'>";
            echo "<h2>Work in Progress</h2>";
            
            if ($content_file && !file_exists($content_file)) {
                 echo "<p style='color: red; font-weight: bold;'>ERROR: File not found at path: " . htmlspecialchars($content_file) . "</p>";
                 echo "<p>Please ensure the section file exists in the correct directory (e.g., sections/manage_users.php).</p>";
            } else {
                 echo "<p>The <b>" . htmlspecialchars($current_section['title']) . "</b> section is currently under development. Please check back later!</p>";
            }
            
            echo "</div>";
        }
        ?>
    </div>
</div>

</body>
</html>
